#ifndef __MT_VIEWER_H__
#define __MT_VIEWER_H__

enum
{
	kSourceFileBase = 1,
	kSourceFileRaw,
	kSourceFileSegment
};

class MTViewer
{
	public:
						MTViewer()	{ viewerResourceName.clear(); }
		
		virtual void	ParseData(UInt8 * buf, UInt32 bufSize) = 0;
		
		void			SetType(UInt32 inType)				{ viewerResourceType = inType; }
		
		void			SetName(char * inName)				{ viewerResourceName = inName; }
		void			SetName(const std::string & inName)	{ viewerResourceName = inName; }
		
		void			SetIdx(UInt32 inIdx)				{ viewerResourceIdx = inIdx; }
		
		void			SetSourceFile(UInt8 inFile)			{ viewerResourceFile = inFile; }
		void			SetSourceOffset(UInt32 inOffset)	{ viewerResourceOffset = inOffset; }
		void			SetSourceSize(UInt32 inSize)		{ viewerResourceSize = inSize; }
	
	protected:
		UInt32			viewerResourceType;
		std::string		viewerResourceName;
		UInt32			viewerResourceIdx;
		
		UInt8			viewerResourceFile;
		UInt32			viewerResourceOffset;
		UInt32			viewerResourceSize;
};

#endif /* __MT_VIEWER_H__ */